/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.ide.eclipse.java;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.libreoffice.ide.eclipse.core.PluginLogger;
import org.libreoffice.ide.eclipse.core.model.IUnoidlProject;
import org.libreoffice.ide.eclipse.core.model.ProjectsManager;
import org.libreoffice.ide.eclipse.java.JavaClassPathProvider;
import org.libreoffice.ide.eclipse.java.registration.ASTParserHelper;
import org.libreoffice.ide.eclipse.java.registration.CompilationUnitHelper;
import org.libreoffice.ide.eclipse.java.registration.RegistrationHelper;

public class JavaResourceDeltaVisitor
implements IResourceDeltaVisitor {
    public boolean visit(IResourceDelta iResourceDelta) throws CoreException {
        boolean bl = true;
        IResource iResource = iResourceDelta.getResource();
        if (iResource != null && iResource.getType() == 1) {
            IFile iFile = (IFile)iResource;
            IUnoidlProject iUnoidlProject = ProjectsManager.getProject((String)iResource.getProject().getName());
            if (iUnoidlProject != null) {
                if (iResourceDelta.getKind() == 1) {
                    this.addImplementation(iUnoidlProject, iFile);
                } else if (iResourceDelta.getKind() == 2) {
                    this.removeImplementation(iUnoidlProject, iFile);
                } else if (iResourceDelta.getKind() == 4) {
                    this.changeProjectResource(iUnoidlProject, iFile);
                }
            }
        }
        return bl;
    }

    private void removeImplementation(IUnoidlProject iUnoidlProject, IFile iFile) throws JavaModelException {
        IType iType;
        ICompilationUnit iCompilationUnit;
        if (this.isJavaSourceFile(iFile) && (iCompilationUnit = JavaCore.createCompilationUnitFrom((IFile)iFile)) != null && (iType = ASTParserHelper.getImplementationType(iCompilationUnit)) != null) {
            RegistrationHelper.removeImplementation(iUnoidlProject, iType.getFullyQualifiedName());
        }
    }

    private void addImplementation(IUnoidlProject iUnoidlProject, IFile iFile) throws JavaModelException {
        if (this.isJavaSourceFile(iFile)) {
            this.changeImplementation(iUnoidlProject, iFile, false);
        }
    }

    private void changeProjectResource(IUnoidlProject iUnoidlProject, IFile iFile) throws JavaModelException {
        if (this.isEclipseClassPath(iFile) && iUnoidlProject.hasBuildFile()) {
            this.changeJavaBuildProperties(iUnoidlProject);
        } else if (this.isJavaSourceFile(iFile)) {
            this.changeImplementation(iUnoidlProject, iFile, true);
        }
    }

    private boolean isJavaSourceFile(IFile iFile) {
        return "java".equals(iFile.getFileExtension());
    }

    private boolean isEclipseClassPath(IFile iFile) {
        return ".classpath".equals(iFile.getName());
    }

    private void changeJavaBuildProperties(IUnoidlProject iUnoidlProject) {
        List<IResource> list = JavaClassPathProvider.getWorkspaceLibs(iUnoidlProject);
        PluginLogger.debug((String)("Found " + list.size() + " Jars"));
        iUnoidlProject.saveJavaBuildProperties(list);
    }

    private void changeImplementation(IUnoidlProject iUnoidlProject, IFile iFile, boolean bl) throws JavaModelException {
        IType iType;
        ICompilationUnit iCompilationUnit = JavaCore.createCompilationUnitFrom((IFile)iFile);
        if (iCompilationUnit != null && (iType = ASTParserHelper.getImplementationType(iCompilationUnit)) != null) {
            this.changeImplementation(iUnoidlProject, new CompilationUnitHelper(iType, iCompilationUnit), bl);
        }
    }

    private void changeImplementation(IUnoidlProject iUnoidlProject, CompilationUnitHelper compilationUnitHelper, boolean bl) throws JavaModelException {
        ASTNode aSTNode = ASTParserHelper.getFieldDeclarationNode((ASTNode)compilationUnitHelper.getCompilationUnit(), "m_serviceNames");
        if (aSTNode != null) {
            this.addImplementation(iUnoidlProject, compilationUnitHelper, aSTNode);
        } else if (bl) {
            RegistrationHelper.removeImplementation(iUnoidlProject, compilationUnitHelper.getTypeName());
        }
    }

    private void addImplementation(IUnoidlProject iUnoidlProject, CompilationUnitHelper compilationUnitHelper, ASTNode aSTNode) throws JavaModelException {
        String[] stringArray = ASTParserHelper.getServiceNames(compilationUnitHelper, aSTNode);
        if (stringArray.length > 0) {
            RegistrationHelper.addImplementation(iUnoidlProject, compilationUnitHelper.getTypeName(), stringArray);
        } else {
            RegistrationHelper.removeImplementation(iUnoidlProject, compilationUnitHelper.getTypeName());
        }
    }
}

