/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.ide.eclipse.java.build;

import java.util.Vector;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.ui.wizards.IClasspathContainerPage;
import org.eclipse.jdt.ui.wizards.IClasspathContainerPageExtension;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.libreoffice.ide.eclipse.core.PluginLogger;
import org.libreoffice.ide.eclipse.core.gui.rows.OOoRow;
import org.libreoffice.ide.eclipse.core.model.IUnoidlProject;
import org.libreoffice.ide.eclipse.core.model.OOoContainer;
import org.libreoffice.ide.eclipse.core.model.ProjectsManager;
import org.libreoffice.ide.eclipse.core.model.config.IOOo;
import org.libreoffice.ide.eclipse.java.OOoJavaPlugin;
import org.libreoffice.ide.eclipse.java.build.Messages;

public class OOoContainerPage
extends WizardPage
implements IClasspathContainerPage,
IClasspathContainerPageExtension {
    private static final int LAYOUT_COLUMNS = 3;
    private static final String OOO = "ooo";
    private IClasspathEntry mContainer;
    private IJavaProject mProject;
    private OOoRow mOOoRow;

    public OOoContainerPage() {
        super("oocontainer");
        this.setTitle(Messages.getString("OOoContainerPage.DialogTitle"));
        this.setDescription(Messages.getString("OOoContainerPage.DialogDescription"));
        String string = Messages.getString("OOoContainerPage.DialogImage");
        ImageDescriptor imageDescriptor = OOoJavaPlugin.getImageDescriptor(string);
        this.setImageDescriptor(imageDescriptor);
        this.mContainer = this.getDefaultEntry();
    }

    private IClasspathEntry getDefaultEntry() {
        IClasspathEntry iClasspathEntry = null;
        IOOo iOOo = OOoContainer.getSomeOOo(null);
        if (iOOo != null) {
            String string = iOOo.getName();
            Path path = new Path("org.libreoffice.ide.eclipse.java.OOO_CONTAINER/" + string);
            iClasspathEntry = JavaCore.newContainerEntry((IPath)path);
        }
        return iClasspathEntry;
    }

    public boolean finish() {
        boolean bl = true;
        try {
            IOOo iOOo = OOoContainer.getOOo((String)this.mOOoRow.getValue());
            String string = this.mProject.getProject().getName();
            IUnoidlProject iUnoidlProject = ProjectsManager.getProject((String)string);
            if (iUnoidlProject != null && iUnoidlProject.getLanguage() != null) {
                iUnoidlProject.setOOo(iOOo);
                iUnoidlProject.saveAllProperties();
            } else {
                OOoContainerPage.removeOOoDependencies(this.mProject);
                IClasspathEntry iClasspathEntry = OOoContainerPage.getOOoLibraryContainer(this.mProject, iOOo);
                OOoContainerPage.addOOoDependencies(this.mProject, iClasspathEntry);
                this.setSelection(iClasspathEntry);
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    public IClasspathEntry getSelection() {
        return this.mContainer;
    }

    public void setSelection(IClasspathEntry iClasspathEntry) {
        this.mContainer = iClasspathEntry;
        if (this.mContainer == null) {
            this.mContainer = this.getDefaultEntry();
        }
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(3, false));
        String string = this.mContainer.getPath().segment(1);
        IOOo iOOo = OOoContainer.getOOo((String)string);
        this.mOOoRow = new OOoRow(composite2, OOO, iOOo);
        this.setControl((Control)composite2);
    }

    public void initialize(IJavaProject iJavaProject, IClasspathEntry[] iClasspathEntryArray) {
        this.mProject = iJavaProject;
        boolean bl = false;
        for (int i = 0; i < iClasspathEntryArray.length && !bl; ++i) {
            IClasspathEntry iClasspathEntry = iClasspathEntryArray[i];
            if (!iClasspathEntry.getPath().segment(0).startsWith("org.libreoffice.ide.eclipse.java.OOO_CONTAINER")) continue;
            bl = true;
            this.mContainer = iClasspathEntry;
        }
    }

    public void dispose() {
        this.mOOoRow.dispose();
        super.dispose();
    }

    public static void addOOoDependencies(IOOo iOOo, IJavaProject iJavaProject) {
        if (null != iOOo) {
            OOoContainerPage.addOOoDependencies(iJavaProject, OOoContainerPage.getOOoLibraryContainer(iJavaProject, iOOo));
        }
    }

    public static void removeOOoDependencies(IJavaProject iJavaProject) {
        try {
            IClasspathEntry[] iClasspathEntryArray = iJavaProject.getRawClasspath();
            Vector<IClasspathEntry> vector = new Vector<IClasspathEntry>();
            for (IClasspathEntry iClasspathEntry : iClasspathEntryArray) {
                if (iClasspathEntry.getPath().segment(0).equals("org.libreoffice.ide.eclipse.java.OOO_CONTAINER")) continue;
                vector.add(iClasspathEntry);
            }
            IClasspathEntry[] iClasspathEntryArray2 = new IClasspathEntry[vector.size()];
            iClasspathEntryArray2 = vector.toArray(iClasspathEntryArray2);
            iJavaProject.setRawClasspath(iClasspathEntryArray2, null);
        }
        catch (JavaModelException javaModelException) {
            PluginLogger.error((String)Messages.getString("OOoContainerPage.ClasspathSetFailed"), (Throwable)javaModelException);
        }
    }

    private static void addOOoDependencies(IJavaProject iJavaProject, IClasspathEntry iClasspathEntry) {
        try {
            IClasspathEntry[] iClasspathEntryArray = iJavaProject.getRawClasspath();
            IClasspathEntry[] iClasspathEntryArray2 = new IClasspathEntry[iClasspathEntryArray.length + 1];
            System.arraycopy(iClasspathEntryArray, 0, iClasspathEntryArray2, 0, iClasspathEntryArray.length);
            iClasspathEntryArray2[iClasspathEntryArray2.length - 1] = iClasspathEntry;
            iJavaProject.setRawClasspath(iClasspathEntryArray2, null);
        }
        catch (JavaModelException javaModelException) {
            PluginLogger.error((String)Messages.getString("OOoContainerPage.ClasspathSetFailed"), (Throwable)javaModelException);
        }
    }

    private static IClasspathEntry getOOoLibraryContainer(IJavaProject iJavaProject, IOOo iOOo) {
        Path path = new Path("org.libreoffice.ide.eclipse.java.OOO_CONTAINER/" + iOOo.getName());
        String string = String.valueOf(JavaRuntime.isModularProject((IJavaProject)iJavaProject));
        IClasspathAttribute iClasspathAttribute = JavaCore.newClasspathAttribute((String)"module", (String)string);
        return JavaCore.newContainerEntry((IPath)path, (IAccessRule[])new IAccessRule[0], (IClasspathAttribute[])new IClasspathAttribute[]{iClasspathAttribute}, (boolean)false);
    }
}

