/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.ide.eclipse.java.client;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.ui.wizards.NewJavaProjectWizardPageOne;
import org.eclipse.jdt.ui.wizards.NewJavaProjectWizardPageTwo;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;
import org.libreoffice.ide.eclipse.core.PluginLogger;
import org.libreoffice.ide.eclipse.core.utils.WorkbenchHelper;
import org.libreoffice.ide.eclipse.java.client.ClientWizardPageTwo;
import org.libreoffice.ide.eclipse.java.client.Messages;
import org.libreoffice.ide.eclipse.java.client.UnoConnectionPage;
import org.libreoffice.ide.eclipse.java.utils.TemplatesHelper;

public class ClientWizard
extends BasicNewResourceWizard {
    public static final String JODCONNECTOR_LIBNAME = "jodconnector.jar";
    private static final String DEST_PACKAGE = "org.libreoffice.client";
    private static final String CLIENT_CLASS = "UnoClient";
    private static final String LICENSE_DIR = "third-party licenses";
    private static final String[] LICENSE_FILES = new String[]{"license-jodconnector.txt"};
    private IWorkbenchPage mActivePage;
    private NewJavaProjectWizardPageOne mFirstPage;
    private NewJavaProjectWizardPageTwo mThirdPage;
    private UnoConnectionPage mCnxPage;

    public ClientWizard() {
        this.setWindowTitle(Messages.getString("ClientWizard.Title"));
        this.mActivePage = WorkbenchHelper.getActivePage();
    }

    public boolean performCancel() {
        boolean bl = super.performCancel();
        this.mThirdPage.performCancel();
        return bl;
    }

    public boolean performFinish() {
        boolean bl = true;
        Job job = new Job(Messages.getString("ClientWizard.CreationJobTitle")){

            protected IStatus run(IProgressMonitor iProgressMonitor) {
                Status status = new Status(0, "org.libreoffice.ide.eclipse.java", Messages.getString("ClientWizard.ProjectCreated"));
                try {
                    ClientWizard.this.mThirdPage.performFinish(iProgressMonitor);
                    ClientWizard.this.setupClientProject(ClientWizard.this.mThirdPage.getJavaProject(), iProgressMonitor);
                }
                catch (Exception exception) {
                    PluginLogger.error((String)Messages.getString("ClientWizard.ProjectCreationError"), (Throwable)exception);
                    status = new Status(4, "org.libreoffice.ide.eclipse.java", Messages.getString("ClientWizard.ProjectCreationError"));
                }
                return status;
            }
        };
        job.schedule();
        return bl;
    }

    protected void setupClientProject(IJavaProject iJavaProject, IProgressMonitor iProgressMonitor) throws Exception {
        IProject iProject = iJavaProject.getProject();
        IClasspathEntry[] iClasspathEntryArray = this.mFirstPage.getSourceClasspathEntries();
        IFolder iFolder = ResourcesPlugin.getWorkspace().getRoot().getFolder(iClasspathEntryArray[0].getPath());
        IPath iPath = iFolder.getProjectRelativePath();
        String string = iPath.append(DEST_PACKAGE.replace('.', '/')).toString();
        TemplatesHelper.copyTemplate(iProject, "UnoClient.java", ClientWizard.class, string, DEST_PACKAGE, this.mCnxPage.getConnectionCode());
        IFolder iFolder2 = iProject.getFolder(LICENSE_DIR);
        iFolder2.create(true, true, iProgressMonitor);
        IPath iPath2 = iFolder2.getProjectRelativePath();
        for (String string2 : LICENSE_FILES) {
            TemplatesHelper.copyTemplate(iProject, string2, ClientWizard.class, iPath2.toString(), new Object[0]);
        }
        try {
            iProject.refreshLocal(2, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        IFolder iFolder3 = iProject.getFolder(string);
        IFile iFile = iFolder3.getFile("UnoClient.java");
        this.selectAndReveal((IResource)iFile);
        WorkbenchHelper.showFile((IFile)iFile, (IWorkbenchPage)this.mActivePage);
    }

    public void addPages() {
        this.mCnxPage = new UnoConnectionPage();
        this.mFirstPage = new NewJavaProjectWizardPageOne();
        this.addPage((IWizardPage)this.mFirstPage);
        this.addPage((IWizardPage)this.mCnxPage);
        this.mThirdPage = new ClientWizardPageTwo(this.mFirstPage, this.mCnxPage);
        this.addPage((IWizardPage)this.mThirdPage);
    }
}

