/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.ide.eclipse.java.registration;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ArrayAccess;
import org.eclipse.jdt.core.dom.ArrayCreation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.libreoffice.ide.eclipse.core.PluginLogger;
import org.libreoffice.ide.eclipse.java.registration.CompilationUnitHelper;
import org.libreoffice.ide.eclipse.java.registration.Messages;

public final class ASTParserHelper {
    public static final IType getImplementationType(ICompilationUnit iCompilationUnit) throws JavaModelException {
        IType iType = null;
        String[] stringArray = new String[]{"QXComponentContext;"};
        IType[] iTypeArray = iCompilationUnit.getAllTypes();
        for (int i = 0; i < iTypeArray.length && iType == null; ++i) {
            IType iType2 = iTypeArray[i];
            IMethod iMethod = iType2.getMethod(iType2.getElementName(), stringArray);
            if (!iMethod.exists() || !iMethod.isConstructor()) continue;
            iType = iType2;
        }
        return iType;
    }

    public static final ASTNode getFieldDeclarationNode(ASTNode aSTNode, String string) {
        return NodeFinder.getFieldDeclarationNode(aSTNode, string);
    }

    public static final String[] getServiceNames(CompilationUnitHelper compilationUnitHelper, ASTNode aSTNode) {
        ArrayList<String> arrayList = new ArrayList<String>();
        ASTParserHelper.parseNode(arrayList, new ArrayList<Integer>(), compilationUnitHelper, aSTNode, null, null, -1);
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private static void parseNode(List<String> list, List<Integer> list2, CompilationUnitHelper compilationUnitHelper, ASTNode aSTNode, ASTNode aSTNode2, ASTNode aSTNode3, int n) {
        if (aSTNode != null) {
            ASTParserHelper.parseNextNode(list, list2, compilationUnitHelper, aSTNode, aSTNode2, aSTNode3, n);
        } else {
            ASTParserHelper.logParserError(aSTNode2, "ASTParserHelper.ParseError");
        }
    }

    private static final void logParserError(ASTNode aSTNode, String string) {
        String string2 = ASTNode.nodeClassForType((int)aSTNode.getNodeType()).getSimpleName();
        PluginLogger.debug((String)String.format(Messages.getString(string), string2, aSTNode.toString()));
    }

    private static void parseNextNode(List<String> list, List<Integer> list2, CompilationUnitHelper compilationUnitHelper, ASTNode aSTNode, ASTNode aSTNode2, ASTNode aSTNode3, int n) {
        switch (aSTNode.getNodeType()) {
            case 23: {
                ASTParserHelper.parseFieldDeclaration(list, list2, compilationUnitHelper, (FieldDeclaration)aSTNode, aSTNode2, aSTNode3, n);
                break;
            }
            case 60: {
                ASTParserHelper.parseVariableDeclarationStatement(list, list2, compilationUnitHelper, (VariableDeclarationStatement)aSTNode, aSTNode2, aSTNode3, n);
                break;
            }
            case 4: {
                ASTParserHelper.parseArrayInitializer(list, list2, compilationUnitHelper, (ArrayInitializer)aSTNode, aSTNode2, aSTNode3, n);
                break;
            }
            case 8: {
                ASTParserHelper.parseBlock(list, list2, compilationUnitHelper, (Block)aSTNode, aSTNode2, aSTNode3, n);
                break;
            }
            case 7: {
                ASTParserHelper.parseAssignment(list, list2, compilationUnitHelper, (Assignment)aSTNode, aSTNode2, aSTNode3, n);
                break;
            }
            case 34: {
                ASTParserHelper.parseNumberLiteral(list, list2, compilationUnitHelper, (NumberLiteral)aSTNode, aSTNode2, aSTNode3, n);
                break;
            }
            case 42: {
                ASTParserHelper.parseSimpleName(list, list2, compilationUnitHelper, (SimpleName)aSTNode, aSTNode2, aSTNode3, n);
                break;
            }
            case 32: {
                ASTParserHelper.parseMethodInvocation(list, list2, compilationUnitHelper, (MethodInvocation)aSTNode, aSTNode2, aSTNode3, n);
                break;
            }
            case 59: {
                ASTParserHelper.parseVariableDeclarationFragment(list, list2, compilationUnitHelper, (VariableDeclarationFragment)aSTNode, aSTNode2, aSTNode3, n);
                break;
            }
            case 3: {
                ASTParserHelper.parseArrayCreation(list, list2, compilationUnitHelper, (ArrayCreation)aSTNode, aSTNode2, aSTNode3, n);
                break;
            }
            case 2: {
                ASTParserHelper.parseArrayAccess(list, list2, compilationUnitHelper, (ArrayAccess)aSTNode, aSTNode2, aSTNode3, n);
                break;
            }
            case 21: {
                ASTParserHelper.parseExpressionStatement(list, list2, compilationUnitHelper, (ExpressionStatement)aSTNode, aSTNode2, aSTNode3, n);
                break;
            }
            case 31: {
                ASTParserHelper.parseMethoddDeclaration(list, list2, compilationUnitHelper, (MethodDeclaration)aSTNode, aSTNode2, aSTNode3, n);
                break;
            }
            case 41: {
                ASTParserHelper.parseReturnStatement(list, list2, compilationUnitHelper, (ReturnStatement)aSTNode, aSTNode2, aSTNode3, n);
                break;
            }
            case 45: {
                ASTParserHelper.parseStringLiteral(list, list2, (StringLiteral)aSTNode, n);
                break;
            }
            default: {
                ASTParserHelper.logParserError(aSTNode, "ASTParserHelper.UnsupportedNode");
            }
        }
    }

    private static final void parseFieldDeclaration(List<String> list, List<Integer> list2, CompilationUnitHelper compilationUnitHelper, FieldDeclaration fieldDeclaration, ASTNode aSTNode, ASTNode aSTNode2, int n) {
        Iterator iterator = fieldDeclaration.fragments().iterator();
        while (iterator.hasNext()) {
            ASTParserHelper.parseNode(list, list2, compilationUnitHelper, (ASTNode)((VariableDeclarationFragment)iterator.next()), (ASTNode)fieldDeclaration, aSTNode2, n);
        }
    }

    private static final void parseVariableDeclarationStatement(List<String> list, List<Integer> list2, CompilationUnitHelper compilationUnitHelper, VariableDeclarationStatement variableDeclarationStatement, ASTNode aSTNode, ASTNode aSTNode2, int n) {
        Iterator iterator = variableDeclarationStatement.fragments().iterator();
        while (iterator.hasNext()) {
            ASTParserHelper.parseNode(list, list2, compilationUnitHelper, (ASTNode)((VariableDeclarationFragment)iterator.next()), (ASTNode)variableDeclarationStatement, aSTNode2, n);
        }
    }

    private static final void parseArrayInitializer(List<String> list, List<Integer> list2, CompilationUnitHelper compilationUnitHelper, ArrayInitializer arrayInitializer, ASTNode aSTNode, ASTNode aSTNode2, int n) {
        Iterator iterator = arrayInitializer.expressions().iterator();
        while (iterator.hasNext()) {
            ASTParserHelper.parseNode(list, list2, compilationUnitHelper, (ASTNode)((Expression)iterator.next()), (ASTNode)arrayInitializer, aSTNode2, n);
        }
    }

    private static final void parseBlock(List<String> list, List<Integer> list2, CompilationUnitHelper compilationUnitHelper, Block block, ASTNode aSTNode, ASTNode aSTNode2, int n) {
        Iterator iterator = block.statements().iterator();
        while (iterator.hasNext()) {
            ASTParserHelper.parseNode(list, list2, compilationUnitHelper, (ASTNode)((Statement)iterator.next()), (ASTNode)block, aSTNode2, n);
        }
    }

    private static final void parseAssignment(List<String> list, List<Integer> list2, CompilationUnitHelper compilationUnitHelper, Assignment assignment, ASTNode aSTNode, ASTNode aSTNode2, int n) {
        ASTParserHelper.parseNode(list, list2, compilationUnitHelper, (ASTNode)assignment.getLeftHandSide(), (ASTNode)assignment, (ASTNode)assignment.getRightHandSide(), n);
    }

    private static final void parseNumberLiteral(List<String> list, List<Integer> list2, CompilationUnitHelper compilationUnitHelper, NumberLiteral numberLiteral, ASTNode aSTNode, ASTNode aSTNode2, int n) {
        Object object = numberLiteral.resolveConstantExpressionValue();
        if (object != null) {
            ASTParserHelper.parseNode(list, list2, compilationUnitHelper, aSTNode2, (ASTNode)numberLiteral, null, (Integer)object);
        } else {
            ASTParserHelper.parseNode(list, list2, compilationUnitHelper, null, (ASTNode)numberLiteral, aSTNode2, n);
        }
    }

    private static final void parseSimpleName(List<String> list, List<Integer> list2, CompilationUnitHelper compilationUnitHelper, SimpleName simpleName, ASTNode aSTNode, ASTNode aSTNode2, int n) {
        IBinding iBinding = simpleName.resolveBinding();
        if (iBinding != null) {
            ASTParserHelper.parseNode(list, list2, compilationUnitHelper, compilationUnitHelper.findDeclaringNode(iBinding.getKey()), (ASTNode)simpleName, aSTNode2, n);
        } else {
            ASTParserHelper.parseNode(list, list2, compilationUnitHelper, null, (ASTNode)simpleName, aSTNode2, n);
        }
    }

    private static final void parseMethodInvocation(List<String> list, List<Integer> list2, CompilationUnitHelper compilationUnitHelper, MethodInvocation methodInvocation, ASTNode aSTNode, ASTNode aSTNode2, int n) {
        IMethodBinding iMethodBinding = methodInvocation.resolveMethodBinding();
        if (iMethodBinding != null) {
            ASTParserHelper.parseNode(list, list2, compilationUnitHelper, compilationUnitHelper.findDeclaringNode(iMethodBinding.getKey()), (ASTNode)methodInvocation, aSTNode2, n);
        } else {
            ASTParserHelper.parseNode(list, list2, compilationUnitHelper, null, (ASTNode)methodInvocation, aSTNode2, n);
        }
    }

    private static final void parseVariableDeclarationFragment(List<String> list, List<Integer> list2, CompilationUnitHelper compilationUnitHelper, VariableDeclarationFragment variableDeclarationFragment, ASTNode aSTNode, ASTNode aSTNode2, int n) {
        ASTParserHelper.parseNode(list, list2, compilationUnitHelper, (ASTNode)variableDeclarationFragment.getInitializer(), (ASTNode)variableDeclarationFragment, aSTNode2, n);
    }

    private static final void parseArrayCreation(List<String> list, List<Integer> list2, CompilationUnitHelper compilationUnitHelper, ArrayCreation arrayCreation, ASTNode aSTNode, ASTNode aSTNode2, int n) {
        ArrayInitializer arrayInitializer = arrayCreation.getInitializer();
        if (arrayInitializer != null) {
            ASTParserHelper.parseNode(list, list2, compilationUnitHelper, (ASTNode)arrayInitializer, (ASTNode)arrayCreation, aSTNode2, n);
        }
    }

    private static final void parseArrayAccess(List<String> list, List<Integer> list2, CompilationUnitHelper compilationUnitHelper, ArrayAccess arrayAccess, ASTNode aSTNode, ASTNode aSTNode2, int n) {
        ASTParserHelper.parseNode(list, list2, compilationUnitHelper, (ASTNode)arrayAccess.getIndex(), (ASTNode)arrayAccess, aSTNode2, n);
    }

    private static final void parseExpressionStatement(List<String> list, List<Integer> list2, CompilationUnitHelper compilationUnitHelper, ExpressionStatement expressionStatement, ASTNode aSTNode, ASTNode aSTNode2, int n) {
        ASTParserHelper.parseNode(list, list2, compilationUnitHelper, (ASTNode)expressionStatement.getExpression(), (ASTNode)expressionStatement, aSTNode2, n);
    }

    private static final void parseMethoddDeclaration(List<String> list, List<Integer> list2, CompilationUnitHelper compilationUnitHelper, MethodDeclaration methodDeclaration, ASTNode aSTNode, ASTNode aSTNode2, int n) {
        ASTParserHelper.parseNode(list, list2, compilationUnitHelper, (ASTNode)methodDeclaration.getBody(), (ASTNode)methodDeclaration, aSTNode2, n);
    }

    private static final void parseReturnStatement(List<String> list, List<Integer> list2, CompilationUnitHelper compilationUnitHelper, ReturnStatement returnStatement, ASTNode aSTNode, ASTNode aSTNode2, int n) {
        ASTParserHelper.parseNode(list, list2, compilationUnitHelper, (ASTNode)returnStatement.getExpression(), (ASTNode)returnStatement, aSTNode2, n);
    }

    private static final void parseStringLiteral(List<String> list, List<Integer> list2, StringLiteral stringLiteral, int n) {
        int n2 = list2.size();
        for (int i = 0; i < list2.size(); ++i) {
            if (list2.get(i) <= n || n2 <= i) continue;
            n2 = i;
        }
        list2.add(n2, n);
        list.add(n2, stringLiteral.getLiteralValue());
    }

    private static final class NodeFinder
    extends ASTVisitor {
        private ASTNode mNode = null;
        private String mName;

        private NodeFinder(String string) {
            this.mName = string;
        }

        public static ASTNode getFieldDeclarationNode(ASTNode aSTNode, String string) {
            NodeFinder nodeFinder = new NodeFinder(string);
            aSTNode.accept((ASTVisitor)nodeFinder);
            return nodeFinder.mNode;
        }

        public boolean visit(VariableDeclarationFragment variableDeclarationFragment) {
            ASTNode aSTNode;
            boolean bl;
            boolean bl2 = bl = this.mNode == null;
            if (bl && this.mName.equals(variableDeclarationFragment.getName().getIdentifier()) && (aSTNode = variableDeclarationFragment.getParent()).getNodeType() == 23) {
                FieldDeclaration fieldDeclaration = (FieldDeclaration)aSTNode;
                bl = !this.isServiceNamesField(fieldDeclaration);
            }
            return bl;
        }

        private boolean isServiceNamesField(FieldDeclaration fieldDeclaration) {
            return this.isStaticFinal(fieldDeclaration.getModifiers()) && fieldDeclaration.getType().isArrayType() && this.isArrayElementString(fieldDeclaration);
        }

        private boolean isStaticFinal(int n) {
            return (n & 8) == 8 && (n & 0x10) == 16;
        }

        private boolean isArrayElementString(FieldDeclaration fieldDeclaration) {
            SimpleType simpleType;
            boolean bl = false;
            ArrayType arrayType = (ArrayType)fieldDeclaration.getType();
            Type type = arrayType.getElementType();
            if (type.isSimpleType() && (simpleType = (SimpleType)type).getName().getFullyQualifiedName().equals("String")) {
                this.mNode = fieldDeclaration;
                bl = true;
            }
            return bl;
        }
    }
}

