/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.ide.eclipse.java.registration;

import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.StringLiteral;

public final class CompilationUnitHelper {
    private IType mType = null;
    private CompilationUnit mUnit = null;
    private String mKey = null;
    private String mPattern = "Ljava/lang/Class<L%s;>;.getName()Ljava/lang/String;";

    public CompilationUnitHelper(IType iType, ICompilationUnit iCompilationUnit) {
        this.mType = iType;
        this.mUnit = this.getCompilationUnit(iCompilationUnit);
        this.mKey = String.format(this.mPattern, this.getTypeName().replace('.', '/'));
    }

    public CompilationUnit getCompilationUnit() {
        return this.mUnit;
    }

    public String getTypeName() {
        return this.mType.getFullyQualifiedName();
    }

    public ASTNode findDeclaringNode(String string) {
        Object object = null;
        object = this.mKey.equals(string) ? this.getKeyLiteral() : this.mUnit.findDeclaringNode(string);
        return object;
    }

    private CompilationUnit getCompilationUnit(ICompilationUnit iCompilationUnit) {
        ASTParser aSTParser = ASTParser.newParser((int)AST.getJLSLatest());
        aSTParser.setKind(8);
        aSTParser.setResolveBindings(true);
        aSTParser.setSource(iCompilationUnit);
        return (CompilationUnit)aSTParser.createAST(null);
    }

    private StringLiteral getKeyLiteral() {
        StringLiteral stringLiteral = this.mUnit.getAST().newStringLiteral();
        stringLiteral.setLiteralValue(this.getTypeName());
        return stringLiteral;
    }
}

