/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.ide.eclipse.java.registration;

import org.libreoffice.ide.eclipse.core.model.IUnoidlProject;
import org.libreoffice.ide.eclipse.java.utils.TemplatesHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class RegistrationHelper {
    public static final String CLASS_FILENAME = "RegistrationHandler";

    public static void generateFiles(IUnoidlProject iUnoidlProject) {
        TemplatesHelper.copyTemplate(iUnoidlProject, "RegistrationHandler.java", RegistrationHelper.class, new String(), new Object[0]);
    }

    public static void addImplementation(IUnoidlProject iUnoidlProject, String string, String[] stringArray) {
        boolean bl;
        Element element;
        Element element2 = null;
        Document document = iUnoidlProject.getComponentsDocument();
        if (document != null) {
            element2 = iUnoidlProject.getComponentsElement(document);
        }
        if (element2 != null && (element = RegistrationHelper.getJavaComponent(iUnoidlProject, document, element2)) != null && (bl = RegistrationHelper.addImplementation(iUnoidlProject, document, element, string, stringArray))) {
            iUnoidlProject.writeComponentsFile(document);
        }
    }

    public static void removeImplementation(IUnoidlProject iUnoidlProject, String string) {
        Element element;
        Element element2;
        boolean bl = false;
        Document document = iUnoidlProject.getComponentsDocument(false);
        if (document != null && (element2 = iUnoidlProject.getComponentsElement(document)) != null && (element = RegistrationHelper.getJavaComponent(iUnoidlProject, document, element2, false)) != null) {
            bl = iUnoidlProject.removeImplementation(element2, element, string);
        }
        if (bl) {
            iUnoidlProject.writeComponentsFile(document);
        }
    }

    public static String getRegistrationClassName(IUnoidlProject iUnoidlProject) {
        String string = iUnoidlProject.getCompanyPrefix() + "." + iUnoidlProject.getOutputExtension();
        return string + "." + CLASS_FILENAME;
    }

    private static boolean addImplementation(IUnoidlProject iUnoidlProject, Document document, Element element, String string, String[] stringArray) {
        boolean bl = false;
        RegistrationHelper.setComponentUri(element, iUnoidlProject);
        Element element2 = iUnoidlProject.getImplementationElement(element, string);
        if (element2 != null) {
            bl = iUnoidlProject.addServiceElements(document, element2, stringArray);
        } else {
            iUnoidlProject.createImplementation(document, element, string, stringArray);
            bl = true;
        }
        return bl;
    }

    private static Element getJavaComponent(IUnoidlProject iUnoidlProject, Document document, Element element) {
        return RegistrationHelper.getJavaComponent(iUnoidlProject, document, element, true);
    }

    private static Element getJavaComponent(IUnoidlProject iUnoidlProject, Document document, Element element, boolean bl) {
        Element element2 = null;
        NodeList nodeList = element.getElementsByTagName("component");
        for (int i = 0; i < nodeList.getLength() && element2 == null; ++i) {
            Element element3;
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || !RegistrationHelper.isJavaComponent(element3 = (Element)node)) continue;
            element2 = element3;
        }
        if (element2 == null && bl) {
            element2 = RegistrationHelper.createJavaComponent(iUnoidlProject, document, element);
        }
        return element2;
    }

    private static Element createJavaComponent(IUnoidlProject iUnoidlProject, Document document, Element element) {
        Element element2 = document.createElement("component");
        element2.setAttribute("loader", "com.sun.star.loader.Java2");
        RegistrationHelper.setComponentUri(element2, iUnoidlProject);
        element.appendChild(element2);
        return element2;
    }

    private static boolean isJavaComponent(Element element) {
        return element.hasAttribute("loader") && element.getAttribute("loader").equals("com.sun.star.loader.Java2");
    }

    private static void setComponentUri(Element element, IUnoidlProject iUnoidlProject) {
        element.setAttribute("uri", iUnoidlProject.getName() + ".jar");
    }
}

