/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.ide.eclipse.java.tests;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.libreoffice.ide.eclipse.core.PluginLogger;
import org.libreoffice.ide.eclipse.core.model.IUnoidlProject;
import org.libreoffice.ide.eclipse.java.tests.Messages;
import org.libreoffice.ide.eclipse.java.utils.TemplatesHelper;

public class TestsHelper {
    private static final String[] TEMPLATES = new String[]{"UnoTests", "base/UnoSuite", "helper/UnoHelper", "uno/WriterTest"};
    private static final String TEST_PATH = "tests";
    private static final String JUNIT_CONTAINER = "org.eclipse.jdt.junit.JUNIT_CONTAINER";
    private static final String JUNIT4 = "4";
    private static final IPath JUNIT4_PATH = new Path("org.eclipse.jdt.junit.JUNIT_CONTAINER").append("4");

    public static void writeTestClasses(IUnoidlProject iUnoidlProject) {
        for (String string : TEMPLATES) {
            TemplatesHelper.copyTemplate(iUnoidlProject, string + ".java", TestsHelper.class, TEST_PATH, new Object[0]);
        }
    }

    public static void addJUnitLibraries(IJavaProject iJavaProject) {
        try {
            IClasspathEntry iClasspathEntry;
            IClasspathEntry[] iClasspathEntryArray = iJavaProject.getRawClasspath();
            IClasspathEntry[] iClasspathEntryArray2 = new IClasspathEntry[iClasspathEntryArray.length + 1];
            System.arraycopy(iClasspathEntryArray, 0, iClasspathEntryArray2, 0, iClasspathEntryArray.length);
            iClasspathEntryArray2[iClasspathEntryArray2.length - 1] = iClasspathEntry = JavaCore.newContainerEntry((IPath)JUNIT4_PATH);
            iJavaProject.setRawClasspath(iClasspathEntryArray2, null);
        }
        catch (JavaModelException javaModelException) {
            PluginLogger.error((String)Messages.getString("TestsHelper.AddJUnitError"), (Throwable)javaModelException);
        }
    }
}

