/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.ide.eclipse.python;

import com.python.pydev.debug.remote.client_api.PydevRemoteDebuggerServer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.sourcelookup.ISourcePathComputer;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.swt.widgets.Display;
import org.libreoffice.ide.eclipse.core.PluginLogger;
import org.libreoffice.ide.eclipse.core.model.IUnoidlProject;
import org.libreoffice.ide.eclipse.core.model.config.IExtraOptionsProvider;
import org.libreoffice.ide.eclipse.core.model.config.NullExtraOptionsProvider;
import org.libreoffice.ide.eclipse.core.model.language.AbstractLanguage;
import org.libreoffice.ide.eclipse.core.model.language.ILanguageBuilder;
import org.libreoffice.ide.eclipse.core.model.language.IProjectHandler;
import org.libreoffice.ide.eclipse.python.PythonBuilder;
import org.libreoffice.ide.eclipse.python.PythonProjectHandler;

public class Language
extends AbstractLanguage {
    public ILanguageBuilder getLanguageBuilder() {
        return new PythonBuilder();
    }

    public IProjectHandler getProjectHandler() {
        return new PythonProjectHandler();
    }

    public void connectDebuggerToOffice(IUnoidlProject iUnoidlProject, ILaunch iLaunch, IPath iPath, IProgressMonitor iProgressMonitor) {
        try {
            if (PydevRemoteDebuggerServer.isRunning()) {
                iUnoidlProject.getOOo().runOffice(iUnoidlProject, iLaunch, iPath, (IExtraOptionsProvider)new NullExtraOptionsProvider(), iProgressMonitor);
            } else {
                Display.getDefault().asyncExec((Runnable)new debugSeverStart(iUnoidlProject, iLaunch, iPath, iProgressMonitor));
            }
        }
        catch (Exception exception) {
            PluginLogger.error((String)"Could not go for Debugging Mode.", (Throwable)exception);
        }
    }

    public void configureSourceLocator(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) throws CoreException {
        String string = iLaunchConfigurationWorkingCopy.getAttribute("org.libreoffice.ide.eclipse.core.PROJECT_ATTR", "");
        iLaunchConfigurationWorkingCopy.setAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_ID, "org.eclipse.jdt.launching.sourceLocator.JavaSourceLookupDirector");
        iLaunchConfigurationWorkingCopy.setAttribute(ISourcePathComputer.ATTR_SOURCE_PATH_COMPUTER_ID, "org.eclipse.jdt.launching.sourceLookup.javaSourcePathComputer");
        iLaunchConfigurationWorkingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, string);
    }

    private class debugSeverStart
    implements Runnable {
        private IUnoidlProject mPrj;
        private ILaunch mLaunch;
        private IPath mUserInstallation;
        private IProgressMonitor mMonitor;

        public debugSeverStart(IUnoidlProject iUnoidlProject, ILaunch iLaunch, IPath iPath, IProgressMonitor iProgressMonitor) {
            this.mPrj = iUnoidlProject;
            this.mLaunch = iLaunch;
            this.mUserInstallation = iPath;
            this.mMonitor = iProgressMonitor;
        }

        @Override
        public void run() {
            try {
                PydevRemoteDebuggerServer.startServer();
                this.mPrj.getOOo().runOffice(this.mPrj, this.mLaunch, this.mUserInstallation, (IExtraOptionsProvider)new NullExtraOptionsProvider(), this.mMonitor);
            }
            catch (Exception exception) {
                PluginLogger.error((String)"Could not start the debug server and start the LibreOffice Instance.", (Throwable)exception);
            }
        }
    }
}

