/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.ide.eclipse.python;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.libreoffice.ide.eclipse.core.PluginLogger;
import org.libreoffice.ide.eclipse.core.model.IUnoidlProject;
import org.libreoffice.ide.eclipse.core.model.ProjectsManager;
import org.libreoffice.ide.eclipse.core.model.UnoFactoryData;
import org.libreoffice.ide.eclipse.core.model.config.IOOo;
import org.libreoffice.ide.eclipse.core.model.language.IProjectHandler;
import org.libreoffice.ide.eclipse.core.utils.WorkbenchHelper;
import org.libreoffice.ide.eclipse.python.Messages;
import org.libreoffice.ide.eclipse.python.utils.TemplatesHelper;

public class PythonProjectHandler
implements IProjectHandler {
    private static final String SOURCE_BASIS = "/source";
    private static final String PYTHON_TEMPLATE = "StartingPythonClass.py";
    private static final String PYTHON_NATURE = "org.python.pydev.pythonNature";
    private static final String PYTHON_BUILDER = "org.python.pydev.PyDevBuilder";

    public void addOOoDependencies(IOOo iOOo, IProject iProject) {
    }

    public void addProjectNature(IProject iProject) {
        try {
            if (!iProject.exists()) {
                iProject.create(null);
                PluginLogger.debug((String)"Project created during language specific operation");
            }
            if (!iProject.isOpen()) {
                iProject.open(null);
                PluginLogger.debug((String)"Project opened");
            }
            IProjectDescription iProjectDescription = iProject.getDescription();
            String[] stringArray = iProjectDescription.getNatureIds();
            String[] stringArray2 = new String[stringArray.length + 1];
            System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
            stringArray2[stringArray.length] = PYTHON_NATURE;
            ICommand[] iCommandArray = iProjectDescription.getBuildSpec();
            ICommand iCommand = iProjectDescription.newCommand();
            iCommand.setBuilderName(PYTHON_BUILDER);
            List<ICommand> list = Arrays.asList(iCommandArray);
            if (!list.contains(iCommand)) {
                ICommand[] iCommandArray2 = new ICommand[iCommandArray.length + 1];
                iCommandArray2[0] = iCommand;
                System.arraycopy(iCommandArray, 0, iCommandArray2, 1, iCommandArray.length);
                iProjectDescription.setBuildSpec(iCommandArray2);
            }
            iProjectDescription.setNatureIds(stringArray2);
            iProject.setDescription(iProjectDescription, null);
            PluginLogger.debug((String)Messages.getString("Language.PythonNatureBuilderSet"));
        }
        catch (CoreException coreException) {
            PluginLogger.error((String)Messages.getString("Language.NatureSettingFailed"));
        }
    }

    public void configureProject(UnoFactoryData unoFactoryData, IProgressMonitor iProgressMonitor) throws Exception {
        IProject iProject = (IProject)unoFactoryData.getProperty("project_handle");
        IUnoidlProject iUnoidlProject = ProjectsManager.getProject((String)iProject.getName());
        String string = iUnoidlProject.getSourcePath().toPortableString();
        if (string == null || string.equals("")) {
            string = SOURCE_BASIS;
        }
        IFolder iFolder = iProject.getFolder(string);
        iFolder.create(true, true, iProgressMonitor);
        IPath iPath = iFolder.getProjectRelativePath();
        Object[] objectArray = new Object[]{iProject.getName()};
        TemplatesHelper.copyTemplate(iProject, PYTHON_TEMPLATE, PythonProjectHandler.class, iPath.toString(), false, objectArray);
        try {
            iProject.refreshLocal(2, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        IFolder iFolder2 = iProject.getFolder(iPath);
        IFile iFile = iFolder2.getFile(iProject.getName() + ".py");
        IWorkbenchWindow[] iWorkbenchWindowArray = PlatformUI.getWorkbench().getWorkbenchWindows();
        WorkbenchHelper.showFile((IFile)iFile, (IWorkbenchPage)iWorkbenchWindowArray[0].getActivePage());
    }

    public String getImplementationName(IUnoidlProject iUnoidlProject, String string) throws Exception {
        return null;
    }

    public IPath getImplementationFile(String string) {
        return new Path(string.replace(".", "/") + ".py");
    }

    public String getSkeletonMakerLanguage(UnoFactoryData unoFactoryData) throws Exception {
        return null;
    }

    public void removeOOoDependencies(IOOo iOOo, IProject iProject) {
    }

    public String getLibraryPath(IUnoidlProject iUnoidlProject) {
        return "";
    }

    public IFolder[] getBinFolders(IUnoidlProject iUnoidlProject) {
        return new IFolder[0];
    }
}

