/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.ide.eclipse.python;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.libreoffice.ide.eclipse.core.model.IUnoidlProject;
import org.libreoffice.ide.eclipse.core.model.ProjectsManager;
import org.libreoffice.ide.eclipse.python.RegistrationHelper;

public class PythonResourceDeltaVisitor
implements IResourceDeltaVisitor {
    public boolean visit(IResourceDelta iResourceDelta) throws CoreException {
        boolean bl = true;
        IResource iResource = iResourceDelta.getResource();
        if (iResource != null && iResource.getType() == 1) {
            IFile iFile = (IFile)iResource;
            IUnoidlProject iUnoidlProject = ProjectsManager.getProject((String)iResource.getProject().getName());
            if (iUnoidlProject != null && this.isPythonSourceFile(iFile)) {
                if (iResourceDelta.getKind() == 1) {
                    this.addImplementation(iUnoidlProject, iFile);
                } else if (iResourceDelta.getKind() == 2) {
                    this.removeImplementation(iUnoidlProject, iFile);
                } else if (iResourceDelta.getKind() == 4) {
                    this.changeImplementation(iUnoidlProject, iFile);
                }
            }
        }
        return bl;
    }

    private boolean isPythonSourceFile(IFile iFile) {
        return iFile.getFileExtension().equals("py");
    }

    private void removeImplementation(IUnoidlProject iUnoidlProject, IFile iFile) {
        String string = this.getPythonFileContent(iFile);
        if (string != null) {
            String string2 = iFile.getProjectRelativePath().toString();
            RegistrationHelper.removeImplementation(iUnoidlProject, string2);
        }
    }

    private void addImplementation(IUnoidlProject iUnoidlProject, IFile iFile) {
        String string = this.getPythonFileContent(iFile);
        if (string != null) {
            String string2 = iFile.getProjectRelativePath().toString();
            String string3 = this.getImplementationName(string);
            if (string3 != null) {
                this.addImplementation(iUnoidlProject, string2, string3, string);
            }
        }
    }

    private void changeImplementation(IUnoidlProject iUnoidlProject, IFile iFile) {
        String string = this.getPythonFileContent(iFile);
        if (string != null) {
            String string2 = iFile.getProjectRelativePath().toString();
            String string3 = this.getImplementationName(string);
            if (string3 != null) {
                this.addImplementation(iUnoidlProject, string2, string3, string);
            } else {
                RegistrationHelper.removeImplementation(iUnoidlProject, string2);
            }
        }
    }

    private void addImplementation(IUnoidlProject iUnoidlProject, String string, String string2, String string3) {
        String[] stringArray = this.getServiceNames(string3);
        if (stringArray.length > 0) {
            RegistrationHelper.addImplementation(iUnoidlProject, string, string2, stringArray);
        } else {
            RegistrationHelper.removeImplementation(iUnoidlProject, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getPythonFileContent(IFile iFile) {
        String string = null;
        FileInputStream fileInputStream = null;
        BufferedReader bufferedReader = null;
        try {
            fileInputStream = new FileInputStream(iFile.getLocation().toFile());
            bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
            StringBuffer stringBuffer = new StringBuffer();
            String string2 = bufferedReader.readLine();
            while (string2 != null) {
                stringBuffer.append(string2);
                stringBuffer.append(' ');
                string2 = bufferedReader.readLine();
            }
            String string3 = stringBuffer.toString();
            String string4 = "g_ImplementationHelper\\s*=\\s*";
            if (string3.split(string4 = string4 + "unohelper.ImplementationHelper\\s*\\(\\s*\\)").length > 1) {
                string = string3;
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                bufferedReader.close();
                fileInputStream.close();
            }
            catch (Exception exception) {}
        }
        return string;
    }

    private String getImplementationName(String string) {
        String string2 = null;
        String string3 = "g_ImplementationName\\s*=\\s*";
        String string4 = this.getPropertyValue(string, string3 = string3 + "[\"']([^\"' ][\\w\\.\\-_]+)[\"']");
        if (string4 != null) {
            string2 = string4.trim();
        }
        return string2;
    }

    private String[] getServiceNames(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = "g_ServiceNames\\s*=\\s*";
        String string3 = this.getPropertyValue(string, string2 = string2 + "[\\(\\[]([^\\(\\)\\[\\]][\\w\\.\\-_\\s,\"']+)[\\)\\]]");
        if (string3 != null) {
            for (String string4 : string3.split(",")) {
                String string5 = string4.trim().replace("'", "").replace("\"", "");
                if (string5.isBlank()) continue;
                arrayList.add(string5);
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private String getPropertyValue(String string, String string2) {
        String string3 = null;
        Matcher matcher = Pattern.compile(string2).matcher(string);
        if (matcher.find()) {
            string3 = matcher.group(1);
        }
        return string3;
    }
}

