/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.ide.eclipse.python.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.text.MessageFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.libreoffice.ide.eclipse.core.PluginLogger;
import org.libreoffice.ide.eclipse.core.model.IUnoidlProject;
import org.libreoffice.ide.eclipse.python.utils.Messages;

public class TemplatesHelper {
    public static final String PYTHON_EXT = ".py";
    private static final String TEMPLATE_EXT = ".tpl";

    public static void copyTemplate(IUnoidlProject iUnoidlProject, String string, Class<?> clazz, String string2, Object ... objectArray) {
        IProject iProject = ResourcesPlugin.getWorkspace().getRoot().getProject(iUnoidlProject.getName());
        IPath iPath = iUnoidlProject.getImplementationPath();
        iPath = iPath.append(string2);
        IFolder iFolder = iUnoidlProject.getFolder(iPath);
        String string3 = iUnoidlProject.getCompanyPrefix() + "." + iUnoidlProject.getOutputExtension();
        Object[] objectArray2 = new Object[objectArray.length + 1];
        objectArray2[0] = string3;
        System.arraycopy(objectArray, 0, objectArray2, 1, objectArray.length);
        TemplatesHelper.copyTemplate(iProject, string, clazz, iFolder.getProjectRelativePath().toString(), true, objectArray2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyTemplate(IProject iProject, String string, Class<?> clazz, String string2, boolean bl, Object ... objectArray) {
        String string3 = string + TEMPLATE_EXT;
        if (!bl) {
            string = iProject.getName() + PYTHON_EXT;
        }
        IProject iProject2 = iProject;
        if (string2 != null && !string2.equals(new String())) {
            iProject2 = iProject.getFolder(string2);
            iProject2.getLocation().toFile().mkdirs();
        }
        OutputStreamWriter outputStreamWriter = null;
        BufferedReader bufferedReader = null;
        InputStream inputStream = null;
        try {
            IFile iFile = iProject2.getFile((IPath)new Path(string));
            File file = iFile.getLocation().toFile();
            if (!file.exists()) {
                file.getParentFile().mkdirs();
                file.createNewFile();
            }
            outputStreamWriter = new FileWriter(file);
            inputStream = clazz.getResourceAsStream(string3);
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            String string4 = bufferedReader.readLine();
            while (string4 != null) {
                string4 = MessageFormat.format(string4, objectArray);
                outputStreamWriter.append(string4 + "\n");
                string4 = bufferedReader.readLine();
            }
        }
        catch (IOException iOException) {
            String string5 = MessageFormat.format(Messages.getString("TemplatesHelper.ErrorPattern"), string, Messages.getString("TemplatesHelper.ReadError"));
            PluginLogger.error((String)string5, (Throwable)iOException);
        }
        finally {
            try {
                bufferedReader.close();
                inputStream.close();
                outputStreamWriter.close();
            }
            catch (Exception exception) {}
        }
    }
}

